/*
 * GerransReadJSONInput.h
 *
 *  Created on: 03 Oct 2023
 *      Author: nx827554
 */

#ifndef READNFCINPUT_H_
#define READNFCINPUT_H_


// declare global system settings variables
extern char dateTime[17];
extern char encryptCert[35];
extern int bitWidth;

typedef enum// flag definitions for ReadNFC
{
  NFCData_Untested = 0,
  NFCData_JSON,
  NFCData_TypeNotFound,
  NFCData_ReadError,
  NFCData_OutofBoundsChars

} NFCDataType_t;

typedef enum// flag definitions for sensorConfigs
{
	Sensor_OK = 0,
	Sensor_Value_not_found,
	active_out_of_bounds,
	sampleRate_out_of_bounds,
	recordConditions_out_of_bounds,
	threshold1_out_of_bounds,
	threshold2_out_of_bounds

} SensorFlag_t;

typedef enum state// flag definitions for processNFC
{
	isError = 0,
	isWorking

} CodeStatus_t;


struct sensorConfigs {// global temporary sensorConfigs (->) indicates global variable name data will be written to
	const char name[17];// name assigned to the sensor in the JSON File; -> virtual SensorId
	const int recordConditionsType;
	int active;// -1: inactive due to error; 1: active; 0: inactive; -> Enable
	int sampleRate; //sample rate in seconds
	int recordConditions;// 1: lessThan; 2: moreThan; 3:inRange; 4:outRange; -> ThsUsageType
	double threshold1;// Only threshold if recordCondition == 1 or 2, lowest thresholdif recordCondition == 3 or 4; -> Th1
	double threshold2;// NULL if recordCondition == 1 or 2, highest threshold if recordCondition == 3 or 4; -> Th2
	SensorFlag_t errorFlag; // determines if there is an error with the sensor
};


extern const int numberOfSensors;// total number of sensors

typedef enum{// defines temporary sensors by number
	temperature = 0,
	SHT40temperature,
	SHT40humidity,
	pressure,
	luminosity,
	imuacc,
	orientation,
	tiltrec

}SensorDefs_t;

CodeStatus_t processNFCInput(char* buffText);
NFCDataType_t ReadNFC(char *buffText, char *newConfigID);

#endif /* GERRANSREADJSONINPUT_H_ */
